﻿//==============================================================================
//
// $File: //depot/indesign_7.0/gm/build/scripts/XHTML for Digital Editions/startup scripts/OEBExportMenuItemLoader.jsx $
//
// Owner: Paul Norton
//
// $Author: pmbuilder $
//
// $DateTime: 2010/02/22 14:31:38 $
//
// $Revision: #1 $
//
// $Change: 742152 $
//
// Copyright 2006 Adobe Systems Incorporated. All rights reserved.
//
//  NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance 
//  with the terms of the Adobe license agreement accompanying it.  If you have received
//  this file from a source other than Adobe, then your use, modification, or 
//  distribution of it requires the prior written permission of Adobe.
//
// Purpose: Export InDesign documents to epub files or Digital Editions
//
// binary scripts cannot use the #targetengine directive.
// #targetengine is required so that the menu item will work (can't let the script unload.)
// so this script isn't binary, the rest of the plug-in will be.
//
//==============================================================================

#targetengine "digital editions"
var DEBUG = false;
var version = "3.0.0";
var build = "023";

function assert( condition, message )
{
		if (DEBUG && !condition) {alert("Assert: "+message);}
}

app.scriptArgs.set('de_version', version);
app.scriptArgs.set('de_build', build);
if (DEBUG == true) {
    app.scriptArgs.set('digital_editions_debug', 'true');
}

if(typeof(OEBExportMenuItem) == 'undefined') 
{
	//------------------------------------------------------------------------------
	// OEBExportMenuItemLoader.getScriptsFolderPath
	//------------------------------------------------------------------------------
	function OEBExportMenuItemLoader()
	{
	}
	//------------------------------------------------------------------------------
	// OEBExportMenuItemLoader.getScriptsFolderPath
	//------------------------------------------------------------------------------
	OEBExportMenuItemLoader.getScriptsFolderPath = function() 
	{
		try {
			var script = app.activeScript;
		} catch(e) {
			// we are running from the ESTK
			var script = File(e.fileName);
		}
		return script.parent.parent;
	} // DEExport.getScriptsFolderPath

	//------------------------------------------------------------------------------
	// OEBExportMenuItemLoader.loadScript
	//------------------------------------------------------------------------------
	OEBExportMenuItemLoader.loadScript = function(filename) 
	{
		return File(OEBExportMenuItemLoader.getScriptsFolderPath() + '/' + filename );
	} //OEBExportMenuItemLoader.loadScript

	OEBExportMenuItemLoader.script = OEBExportMenuItemLoader.loadScript("OEBExportMenuItem.jsxbin");
	if(!OEBExportMenuItemLoader.script.exists)
	{
		OEBExportMenuItemLoader.script = OEBExportMenuItemLoader.loadScript("OEBExportMenuItem.jsx");
	}
	// execute the script
	assert(OEBExportMenuItemLoader.script.exists, "Couldn't find OEBExportMenuItem.jsx* in " + OEBExportMenuItemLoader.getScriptsFolderPath());
	if(OEBExportMenuItemLoader.script.exists) 
	{
		var previousFolder = Folder.current;
		try
		{
			Folder.current = OEBExportMenuItemLoader.getScriptsFolderPath();
			app.doScript(OEBExportMenuItemLoader.script);
		}
		finally
		{
			Folder.changePath(previousFolder);
		}
	}
}